static void mean(String daten) {
    try (var dis = new DataInputStream(new FileInputStream(daten))) {
        double sum = 0.0;
        int n = 0;
        while (dis.available() > 0) {
            n++;
            sum += dis.readDouble();
        }
        IO.println("Mittelwert zur Datei " + daten + ":  " + sum / n);
    } catch (IOException ioe) {
        ioe.printStackTrace();
    }
}

static void createData(String daten) {
    try (var dos = new DataOutputStream(new FileOutputStream(daten))) {
        Random ran = new Random();
        for (int i = 1; i <= 100; i++)
            dos.writeDouble(ran.nextDouble());
    } catch (IOException ioe) {
        ioe.printStackTrace();
    }
}

void main() {
    createData("eingabe.dat");
    mean("eingabe.dat");
}
